/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class CmSocInsuranceDto extends BaseDto {
	
	private static final long serialVersionUID = -434426550128501863L;
	
	// tB[h
	private String kCode           = "";	// ЈR[h
	private Date   insExpectedDate ;	// ЉیKpN
	private String pensionType     = "";	// N
	private String parttimeType    = "";	// p[g敪
	private String employeeType    = "";	// ]ƈ敪
	private String calcInsType     = "";	// Љی敪
	private String nursingInsType  = "";	// ی敪
	private String calcUnemployType= "";	// ٗpی敪
	private String bonusHealthType = "";	// Nیܗ^敪
	private String bonusPensionType= "";	// Nܗ^敪
	private String healthNo        = "";	// Nیԍ
	private int    healthPayment   = 0;	// NیWVz
	private Date   healthGetDate   ;	// Nیi擾
	private String healthLostType  = "";	// Nیir敪
	private Date   healthLostDate  ;	// Nیir
	private String pensionNo       = "";	// Nԍ
	private int    pensionPayment  = 0;	// NWVz
	private Date   pensionGetDate  ;	// Ni擾
	private String pensionLostType = "";	// Nir敪
	private Date   pensionLostDate ;	// Nir
	private String fundNo          = "";	// Nԍ
	private Date   fundGetDate     ;	// Ni擾
	private String unemployNo      = "";	// ٗpیԍ
	private Date   unemployGetDate ;	// ٗpیi擾
	private String unemployLostType= "";	// ٗpیir敪
	private Date   unemployLostDate;	// ٗpیir
	
	/**
	 * RXgN^
	 */
	public CmSocInsuranceDto(){
		super();
	}
	
	// ANZT\bh
	public String getKCode           () { return kCode                         ; }	// ЈR[h
	public Date   getInsExpectedDate () { return getDateField(insExpectedDate ); }	// ЉیKpN
	public String getPensionType     () { return pensionType                   ; }	// N
	public String getParttimeType    () { return parttimeType                  ; }	// p[g敪
	public String getEmployeeType    () { return employeeType                  ; }	// ]ƈ敪
	public String getCalcInsType     () { return calcInsType                   ; }	// Љی敪
	public String getNursingInsType  () { return nursingInsType                ; }	// ی敪
	public String getCalcUnemployType() { return calcUnemployType              ; }	// ٗpی敪
	public String getBonusHealthType () { return bonusHealthType               ; }	// Nیܗ^敪
	public String getBonusPensionType() { return bonusPensionType              ; }	// Nܗ^敪
	public String getHealthNo        () { return healthNo                      ; }	// Nیԍ
	public int    getHealthPayment   () { return healthPayment                 ; }	// NیWVz
	public Date   getHealthGetDate   () { return getDateField(healthGetDate   ); }	// Nیi擾
	public String getHealthLostType  () { return healthLostType                ; }	// Nیir敪
	public Date   getHealthLostDate  () { return getDateField(healthLostDate  ); }	// Nیir
	public String getPensionNo       () { return pensionNo                     ; }	// Nԍ
	public int    getPensionPayment  () { return pensionPayment                ; }	// NWVz
	public Date   getPensionGetDate  () { return getDateField(pensionGetDate  ); }	// Ni擾
	public String getPensionLostType () { return pensionLostType               ; }	// Nir敪
	public Date   getPensionLostDate () { return getDateField(pensionLostDate ); }	// Nir
	public String getFundNo          () { return fundNo                        ; }	// Nԍ
	public Date   getFundGetDate     () { return getDateField(fundGetDate     ); }	// Ni擾
	public String getUnemployNo      () { return unemployNo                    ; }	// ٗpیԍ
	public Date   getUnemployGetDate () { return getDateField(unemployGetDate ); }	// ٗpیi擾
	public String getUnemployLostType() { return unemployLostType              ; }	// ٗpیir敪
	public Date   getUnemployLostDate() { return getDateField(unemployLostDate); }	// ٗpیir
	
	public void setKCode           (String kCode           ) { this.kCode            = kCode                         ; }	// ЈR[h
	public void setInsExpectedDate (Date   insExpectedDate ) { this.insExpectedDate  = getDateField(insExpectedDate ); }	// ЉیKpN
	public void setPensionType     (String pensionType     ) { this.pensionType      = pensionType                   ; }	// N
	public void setParttimeType    (String parttimeType    ) { this.parttimeType     = parttimeType                  ; }	// p[g敪
	public void setEmployeeType    (String employeeType    ) { this.employeeType     = employeeType                  ; }	// ]ƈ敪
	public void setCalcInsType     (String calcInsType     ) { this.calcInsType      = calcInsType                   ; }	// Љی敪
	public void setNursingInsType  (String nursingInsType  ) { this.nursingInsType   = nursingInsType                ; }	// ی敪
	public void setCalcUnemployType(String calcUnemployType) { this.calcUnemployType = calcUnemployType              ; }	// ٗpی敪
	public void setBonusHealthType (String bonusHealthType ) { this.bonusHealthType  = bonusHealthType               ; }	// Nیܗ^敪
	public void setBonusPensionType(String bonusPensionType) { this.bonusPensionType = bonusPensionType              ; }	// Nܗ^敪
	public void setHealthNo        (String healthNo        ) { this.healthNo         = healthNo                      ; }	// Nیԍ
	public void setHealthPayment   (int    healthPayment   ) { this.healthPayment    = healthPayment                 ; }	// NیWVz
	public void setHealthGetDate   (Date   healthGetDate   ) { this.healthGetDate    = getDateField(healthGetDate   ); }	// Nیi擾
	public void setHealthLostType  (String healthLostType  ) { this.healthLostType   = healthLostType                ; }	// Nیir敪
	public void setHealthLostDate  (Date   healthLostDate  ) { this.healthLostDate   = getDateField(healthLostDate  ); }	// Nیir
	public void setPensionNo       (String pensionNo       ) { this.pensionNo        = pensionNo                     ; }	// Nԍ
	public void setPensionPayment  (int    pensionPayment  ) { this.pensionPayment   = pensionPayment                ; }	// NWVz
	public void setPensionGetDate  (Date   pensionGetDate  ) { this.pensionGetDate   = getDateField(pensionGetDate  ); }	// Ni擾
	public void setPensionLostType (String pensionLostType ) { this.pensionLostType  = pensionLostType               ; }	// Nir敪
	public void setPensionLostDate (Date   pensionLostDate ) { this.pensionLostDate  = getDateField(pensionLostDate ); }	// Nir
	public void setFundNo          (String fundNo          ) { this.fundNo           = fundNo                        ; }	// Nԍ
	public void setFundGetDate     (Date   fundGetDate     ) { this.fundGetDate      = getDateField(fundGetDate     ); }	// Ni擾
	public void setUnemployNo      (String unemployNo      ) { this.unemployNo       = unemployNo                    ; }	// ٗpیԍ
	public void setUnemployGetDate (Date   unemployGetDate ) { this.unemployGetDate  = getDateField(unemployGetDate ); }	// ٗpیi擾
	public void setUnemployLostType(String unemployLostType) { this.unemployLostType = unemployLostType              ; }	// ٗpیir敪
	public void setUnemployLostDate(Date   unemployLostDate) { this.unemployLostDate = getDateField(unemployLostDate); }	// ٗpیir
	
}

